/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.config.ConfigUtils;
import com.sonicether.soundphysics.integration.voicechat.AudioChannel;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedProperties;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public class SoundRateConfig
extends CommentedPropertyConfig {
    private Map<class_2960, Integer> soundRateConfig;

    public SoundRateConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
    }

    @Override
    public void load() throws IOException {
        super.load();
        Map<class_2960, Integer> map = this.createDefaultMap();
        for (String key : this.properties.keySet()) {
            int value;
            String valueString = this.properties.get(key);
            if (valueString == null) continue;
            try {
                value = Integer.parseInt(valueString);
            }
            catch (NumberFormatException ignored) {
                try {
                    boolean enabled = Boolean.parseBoolean(valueString);
                    value = enabled ? -1 : 0;
                }
                catch (Exception e) {
                    Loggers.warn("Failed to set sound rate entry {}", key);
                    continue;
                }
            }
            class_2960 resourceLocation = class_2960.method_12829((String)key);
            if (resourceLocation == null) {
                Loggers.warn("Failed to set sound rate entry {}", key);
                continue;
            }
            if (!AudioChannel.isVoicechatSound(resourceLocation)) {
                this.logIfUnknownSound(resourceLocation);
            }
            map.put(resourceLocation, value);
        }
        this.soundRateConfig = ConfigUtils.sortMap(map);
        this.saveSync();
    }

    private void logIfUnknownSound(class_2960 resourceLocation) {
        try {
            class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(resourceLocation);
            if (soundEvent == null) {
                Loggers.log("Unknown sound in sound rate config: {}", resourceLocation);
            }
        }
        catch (Exception e) {
            Loggers.warn("Failed to parse sound rate entry {}", resourceLocation, e);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.addHeaderComment("Max sounds per tick.");
        this.properties.addHeaderComment("Set to '-1' for an unlimited number of sounds per tick processed.");
        this.properties.addHeaderComment("Set to '0' to disable sound physics for that sound.");
        this.properties.addHeaderComment("Set to '>=1' to configure the maximum number of sounds per tick processed.");
        this.properties.addHeaderComment("This can help prevent lag when some mod or mechanism produces hundreds of sounds per tick.");
        for (Map.Entry<class_2960, Integer> entry : this.soundRateConfig.entrySet()) {
            this.properties.set(entry.getKey().toString(), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<class_2960, Integer> getSoundRateConfig() {
        return this.soundRateConfig;
    }

    public Integer getMaxCount(class_2960 soundEvent) {
        int count = this.soundRateConfig.getOrDefault(soundEvent, -1);
        return count <= -1 ? Integer.MAX_VALUE : count;
    }

    public Map<class_2960, Integer> createDefaultMap() {
        HashMap<class_2960, Integer> map = new HashMap<class_2960, Integer>();
        for (class_3414 event : class_7923.field_41172) {
            map.put(event.method_14833(), -1);
        }
        map.put(class_3417.field_14946.method_14833(), 0);
        map.put(class_3417.field_15020.method_14833(), 0);
        map.put(class_3417.field_14865.method_14833(), 0);
        class_3417.field_39028.forEach(r -> map.put(r.method_40237().method_29177(), 0));
        return map;
    }
}

